
# **Example Script `download_all_recordings`**

## **Overview**
The `download_all_recordings` script retrieves and downloads recordings from Dubber's API. It uses credentials stored in an encrypted format for authentication and writes recording metadata and audio files to a local directory.

---

## **Requirements**
To run the script, ensure the following prerequisites are met:

### **1. Python Environment**
- Python version 3.8 or above.
- Required Python libraries:
  - `cryptography`
  - `requests`
  - `configparser`

Install these libraries using:
```bash
pip install cryptography requests configparser
```

### **2. Configuration Files**
The script requires the following files:

#### a) `dubber_auth_v3.py`
Handles authentication with Dubber's API, including encryption, token management, and API calls.

#### b) `config.ini`
Configuration file with necessary details:
```ini
[DEFAULT]
save_path = ./Downloads/recordings
admin_email = admin.email@dubber.net
```
- **`save_path`**: Directory where recordings will be saved. Ensure it exists or the script can create it.
- **`admin_email`**: Email of the Dubber account administrator to fetch recording links.

#### c) Encrypted Tokens
An encryption key (`secret.key`) and encrypted tokens (`tokens.enc`) must be available in the working directory. If not present, the script will prompt you to generate and save them.

---

## **Setup and Configuration**

### **Step 1: Set Up the Configuration**
1. Edit the `config.ini` file to set:
   - The directory to save recordings (`save_path`).
   - The administrator email (`admin_email`).

2. Place `config.ini` in the same directory as the script.

### **Step 2: Generate Encryption Key and Tokens**
There are 2 methods to generating token
***Method 1: Run the script directly***
   ```bash
   python download_all_recordings.py
   ```

***Method 2: Run the following code to generate the keys without running the script***
1. Execute the following in Python:
   ```python
   from dubber_auth_v3 import generate_key, prompt_for_tokens, save_tokens, load_key
   generate_key()  # Creates the secret.key file
   key = load_key()
   tokens = prompt_for_tokens()  # Input credentials
   save_tokens(tokens, key)  # Encrypt and save tokens to tokens.enc
   ```
2. Follow the prompts to input your Dubber credentials:
   - Mashery Key
   - Mashery Secret
   - Dubber Auth ID
   - Dubber Auth Token
   - Select the region (e.g., `us` or `eu`).

### **Step 3: Verify Directory Permissions**
Ensure the script has write access to:
- The directory where `tokens.enc` and `secret.key` are stored.
- The `save_path` directory specified in `config.ini`.

---

## **Running the Script**

1. Execute the script and follow the steps to create a new token.
   ```bash
   python download_all_recordings.py
   ```

2. The script performs the following:
   - Authenticates using `tokens.enc`.
   - Retrieves user profile to get the account ID.
   - Iteratively fetches recordings (100 per batch).
   - Saves recording metadata in JSON format.
   - Downloads recording files in `.mp3` format.

3. Recording files and metadata are saved in the `save_path` directory.

---

## **Error Handling**

### **Common Issues and Fixes**
- **Authentication Failure:**
  - Ensure tokens are correctly encrypted in `tokens.enc`.
  - Verify the `secret.key` is in the same directory.
  - Refresh tokens using the authentication script.

- **Invalid Configuration:**
  - Verify the `config.ini` file is correctly formatted.
  - Ensure the `save_path` exists and is writable.

- **Download Failures:**
  - Check internet connectivity.
  - Verify `admin_email` is correct and has necessary permissions.
  
- **Your Developer Keys:**
  - Ensure that the developers keys Status is 'Active'
  - Ensure that the keys being used are for the correct region

---

## **Customization**
You can modify the script to:
- Change the recording file format (e.g., `.wav` instead of `.mp3`).
- Adjust the batch size for retrieving recordings by editing the `count` parameter in `get_recordings`.
- You can change where and how the save and load tokens are handled to fit your needs
- You can follow the examples listed and add more API functions to accomplish what you need

---

## **Troubleshooting**
- Use verbose logging to debug errors. Add `print()` statements or use a logging library for detailed output.
- Check API responses for detailed error messages.

---
